IF not OBJECT_ID('PDV_VD_IT_OPERADOR_CAIXA_COMISSAO') IS NULL
begin
	DROP TABLE PDV_VD_IT_OPERADOR_CAIXA_COMISSAO
end
GO
IF OBJECT_ID('PDV_VD_IT_OPERADOR_CAIXA_COMISSAO') IS NULL
BEGIN
	CREATE TABLE [dbo].[PDV_VD_IT_OPERADOR_CAIXA_COMISSAO](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_VD] [int] NOT NULL,
		[CD_IT] [int] NOT NULL,
		[PERC_COMI] [money] NOT NULL,
		[DS_PERC_COMIS] [varchar](100) NOT NULL,
		[DS_VLR_COMIS] [varchar](100) NOT NULL,
		[VLR_COMISSAO_FABRIC] [money] NOT NULL,
		[CD_USU] [int] NOT NULL,
	 CONSTRAINT [PK_PDV_VD_IT_OPERADOR_CAIXA_COMISSAO] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_VD] ASC,
		[CD_IT] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[PDV_VD_IT_OPERADOR_CAIXA_COMISSAO] ADD  CONSTRAINT [DF_PDV_VD_IT_OPERADOR_CAIXA_COMISSAO_PERC_COMI]  DEFAULT ((0)) FOR [PERC_COMI]

	ALTER TABLE [dbo].[PDV_VD_IT_OPERADOR_CAIXA_COMISSAO] ADD  CONSTRAINT [DF_PDV_VD_IT_OPERADOR_CAIXA_COMISSAO_DS_PERC_COMIS]  DEFAULT ('') FOR [DS_PERC_COMIS]

	ALTER TABLE [dbo].[PDV_VD_IT_OPERADOR_CAIXA_COMISSAO] ADD  CONSTRAINT [DF_PDV_VD_IT_OPERADOR_CAIXA_COMISSAO_DS_VLR_COMIS]  DEFAULT ('') FOR [DS_VLR_COMIS]

	ALTER TABLE [dbo].[PDV_VD_IT_OPERADOR_CAIXA_COMISSAO] ADD  CONSTRAINT [DF_PDV_VD_IT_OPERADOR_CAIXA_COMISSAO_PERC_COMISSAO_SERVICO]  DEFAULT ((0)) FOR [VLR_COMISSAO_FABRIC]

	ALTER TABLE [dbo].[PDV_VD_IT_OPERADOR_CAIXA_COMISSAO] ADD  CONSTRAINT [DF_PDV_VD_IT_OPERADOR_CAIXA_COMISSAO_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

	ALTER TABLE [dbo].[PDV_VD_IT_OPERADOR_CAIXA_COMISSAO]  WITH CHECK ADD  CONSTRAINT [FK_PDV_VD_IT_OPERADOR_CAIXA_COMISSAO_PDV_VD_IT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_VD], [CD_IT])
	REFERENCES [dbo].[PDV_VD_IT] ([CD_EMP], [CD_FILIAL], [CD_VD], [CD_IT])

	ALTER TABLE [dbo].[PDV_VD_IT_OPERADOR_CAIXA_COMISSAO] CHECK CONSTRAINT [FK_PDV_VD_IT_OPERADOR_CAIXA_COMISSAO_PDV_VD_IT]
end